/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.ui.bonsai.event.EventQueueListener;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorManager;
import com.ibm.hwmca.ui.bonsai.status.event.StatusMonitorPropertyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StatusOverviewModel
implements EventQueueListener,
StatusMonitorPropertyListener {
    private String modelKey;
    private UserObject userObj;
    private List orderedKeyList;
    private Map monitorBeans;
    private boolean reloadPending;

    public StatusOverviewModel(String modelKey, UserObject userObj) {
        this.modelKey = modelKey;
        this.userObj = userObj;
        StatusMonitorManager statusManager = userObj.getStatusMonitorManager();
        this.orderedKeyList = statusManager.getOrderedKeyList();
        this.monitorBeans = statusManager.getStatusMonitorBeans();
        this.reloadPending = false;
    }

    public synchronized List getBeans() {
        ArrayList<Object> beans = new ArrayList<Object>(this.monitorBeans.size());
        Object bean = null;
        Iterator i = this.orderedKeyList.iterator();
        while (i.hasNext()) {
            bean = this.monitorBeans.get(i.next());
            if (bean == null) continue;
            beans.add(bean);
        }
        return beans;
    }

    public synchronized void queueEmpty() {
        if (this.reloadPending && this.userObj.isModelVisible(this.modelKey)) {
            UIRefreshManager.refresh(5, this.userObj.getHMCSession());
        }
        this.reloadPending = false;
    }

    public synchronized void statusChange(String key, StatusMonitorBean monitorBean) {
        if (this.monitorBeans.containsKey(key)) {
            this.monitorBeans.put(key, monitorBean);
            this.reloadPending = true;
        }
    }
}

